	function [G, Z, R_ZEROS, P, wsnew] = CH_I_C_POLES_S(G, Z, P, wc, ws, N)

	% Transforms first the poles of an even order analog lowpass filter of
	% Chebyshev I type A with cutoff frequency wc to have A(0) = 0. 
	% That filter is then transforemed is into a Chevbshev I filter type C.
	% The cutoff edge is invariant, only the stoband edge, ws, is increased.
 
	% Toolbox for DIGITAL FILTERS USING MATLAB
		
	% Author: 			Lars Wanhammar, 2008-07-15
	% Modified by: 		 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	%
	
	 % N must be an integer
	 if ~(abs(N-round(N)) < eps)
		 error('N must be an integeer')  
		 return
	 end
	
	 N = length (P);
	W0 = wc*sin(pi/(2*N));	% Lowest reflection zero
	% Transform the poles
	for n = 1:length(P)
		 P(n) = -sqrt(P(n)^2+W0^2)/cos(pi/(2*N));
	 end
	G = real(prod(P));	% Gain constant
	
	% The new stopband edge is
	wsnew = imag(sqrt((wc*sin(pi/(2*N)))^2 - ws^2)/cos(pi/(2*N)));
	for k = 1:N
		x = i*wc*cos((2*k-1)*pi/2/N);				% Type a
		R_ZEROS(k) = sqrt(wc^2*(W0^2+x^2)/(wc^2-W0^2)); % Transform to type c
	end
 	R_ZEROS = sort(R_ZEROS)';	
 	
